// f.js

let clickCount = 0; // Compteur de clics

function initialiserAjoutDestination(map, control) {
    map.on('click', function(e) {
        const latLng = e.latlng;

        // Ajouter un point de passage
        control.spliceWaypoints(control.getWaypoints().length - 1, 0, latLng);

        // Créer un marqueur pour la destination
        const marker = L.marker(latLng).addTo(map);
        clickCount = 0; // Réinitialiser le compteur

        // Ajouter un gestionnaire de clics pour le marqueur
        marker.on('click', function() {
            clickCount++; // Incrémenter le compteur de clics
            if (clickCount === 2) {
                map.removeLayer(marker); // Supprimer le marqueur après deux clics
                clickCount = 0; // Réinitialiser le compteur
            }
        });
    });
}
